/**
 * @file  CltWfLogCentralDispatcher.cc
 *
 * @brief   Control Workflow LogCentral Dispatcher
 *
 * @author  Benjamin ISNARD (benjamin.isnard@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include "CltWfLogCentralDispatcher.hh"
#include "debug.hh"

#ifdef USE_LOG_SERVICE
CltWfLogCentralDispatcher::CltWfLogCentralDispatcher(DietLogComponent *LC):
  myLC(LC) {
  if (myLC == NULL) {
    INTERNAL_ERROR("Invalid WfLogCentralDispatcher constructor parameter", 1);
  }
  // register event handlers
  registerEventFunc(this, &CltWfLogCentralDispatcher::onDagNodeStart);
  registerEventFunc(this, &CltWfLogCentralDispatcher::onDagNodeFinish);
  registerEventFunc(this, &CltWfLogCentralDispatcher::onDagNodeFailed);
}

void
CltWfLogCentralDispatcher::onDagNodeStart(
  const events::EventFrom< DagNodeLauncher,
                           events::EventStandardMsg< DagNodeLauncher,
                                                     DagNode::START > > *event)
{
  if (event->getSource()->isSeDDefined()) {
    myLC->logWfNodeStart(event->getSource()->getNode()->getDag()->getId().c_str(),
                         event->getSource()->getNode()->getId().c_str(),
                         event->getSource()->getSeDName().c_str(),
                         event->getSource()->getNode()->getPbName().c_str(),
                         event->getSource()->getReqId()
                         );
  } else {
    myLC->logWfNodeStart(event->getSource()->getNode()->getDag()->getId().c_str(),
                         event->getSource()->getNode()->getId().c_str()
                         );
  }
} // onDagNodeStart

void
CltWfLogCentralDispatcher::onDagNodeFinish(
  const events::EventFrom< DagNodeLauncher,
                           events::EventStandardMsg< DagNodeLauncher,
                                                     DagNode::FINISH > > *event)
{
  myLC->logWfNodeFinish(event->getSource()->getNode()->getDag()->getId().c_str(),
                        event->getSource()->getNode()->getId().c_str()
                        );
}

void
CltWfLogCentralDispatcher::onDagNodeFailed(
  const events::EventFrom< DagNodeLauncher,
                           events::EventStandardMsg< DagNodeLauncher,
                                                     DagNode::FAILED > > *event)
{
  myLC->logWfNodeFailed(event->getSource()->getNode()->getDag()->getId().c_str(),
                        event->getSource()->getNode()->getId().c_str()
                        );
}

#endif // ifdef USE_LOG_SERVICE
