/**
* @file FileParser.hh
* 
* @brief  File parser  
* 
* @author  Haikel Guemar (haikel.guemar@sysfera.com)
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/


#ifndef _FILE_PARSER_HH_
#define _FILE_PARSER_HH_

#include <map>
#include <string>

#include "FileException.hh"
#include "CommonParser.hh"

#ifdef __WIN32__
#define DIET_API_LIB __declspec(dllexport)
#else
#define DIET_API_LIB
#endif

/**
 * @author Gael Le Mahec <gael.le.mahec@ens-lyon.fr)
 * @author hguemar <hguemar@sysfera.com>
 *
 * @class FileParser
 * @brief Simple Configuration File Parser
 *
 * support ini-like format, options are stored in a std::map
 */
class DIET_API_LIB FileParser {
public:
  /**
   * @brief default constructor
   */
  FileParser();
  /**
   * @brief constructor
   * @param path path to config file
   */
  explicit FileParser(const std::string& path);
  /**
   * @brief parse configuration file
   * @param path path to config file
   * @exception FileOpenError
   */
  void
  parseFile(const std::string& path);

  /**
   * @brief subscript operator
   * @param key option name
   * @return option value
   */
  std::string&
  operator[](const std::string& key);  // setter
  /**
   * @brief subscript operator
   * @param key option name
   * @return option value
   */
  const std::string&
  operator[](const std::string& key) const;  // getter

  /**
   * @brief return options
   * @return configuration map (key, value)
   */
  const std::map<std::string, std::string>&
  getConfiguration() const;

private:
  mutable OptionMap options_;
};

#endif /* _FILE_PARSER_HH_ */
