/**
 * @file NetworkStats.cc
 *
 * @brief  Network statistics utility classes.
 *
 * @author Gael Le Mahec (lemahec@clermont.in2p3.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#include "NetworkStats.hh"

#include <iostream>

double
NetworkStats::getStat(std::string src, std::string dest) {
  if (values.find(src) != values.end()) {
    return (values[src])[dest];
  } else {return -1;
  }
}

double
AvgNetworkStats::getStat(std::string src, std::string dest) {
  double ret = NetworkStats::getStat(src, dest);
  if (ret == -1) {
    return -1;
  }
  return ret / (nbStats[src])[dest];
}

bool
AvgNetworkStats::cmpStats(double s1, double s2) {
  if (s1 > s2) {
    return true;
  }
  return false;
}

void
AvgNetworkStats::addStat(std::string src, std::string dest, double value) {
  double currentStat = getStat(src, dest);
  if (currentStat == -1) {
    (values[src])[dest] = value;
  } else {
    (values[src])[dest] += value;
  }
  (nbStats[src])[dest]++;
}
